# posner : Posner Memorial Collection#
# 
# This module will allow you to download page images from
# the Posner Memorial Collection site. See the documentation
# for additional details

$module_default_format = "image";

%module_formats = (
  'image'  => 'jpg',
  'jpg'    => 'jpg',
  'jpeg'   => 'jpg',
);


$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};

$module_url{'plistbase'} = "http://posner.library.cmu.edu/Posner/books/CALL5/$idno/vol0/part0/copy0/jpg/lg/";

print_v("Getting page listing... (".$module_url{'plistbase'}.")");
$res = $ua->get($module_url{'plistbase'});

$module_url{'imagebase'} = $module_url{'plistbase'};


$res->content =~ m!(\d+)-lg\.jpg</A>[^<]+<IMG SRC="/icons/folder!s;
$module_available_high = $1;
print_v("This volume has $module_available_high pages...");

$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $module_i = sprintf("%04d",$module_i);
  $module_image_url = $module_url{'imagebase'}.$module_i."-lg.".$config{'ext'};
  print_v("Image URL: $module_image_url");
  push(@urls,$module_image_url);
}