# sceti : Schoenberg Center for Electronic Text & Images#
# This module will allow you to download page images from
# the Schoenberg Center for Electronic Text & Image site.
# See the documentation for additional details


print_v("Renumbering images!");
$config{'renumber'} = 1;


$module_default_format = "image";

%module_formats = (
  'image'  => 'jpg',
  'jpg'    => 'jpg',
  'jpeg'   => 'jpg',
);

# This subroutine will check to make sure the module
$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};


$module_url{'plistbase'} = "http://dewey.library.upenn.edu/sceti/printedbooksNew/title20020107.cfm?CurrentCollection=stc&PagePosition=1&TextID=$idno";
$module_url{'imagebase'} = "http://images.library.upenn.edu/mrsidsceti/bin/image_jpeg.pl?coll=printedbooks&subcoll=$idno&level=0&image=${idno}_body";


print_v("Getting page listing... (".$module_url{'plistbase'}.")");
$res = $ua->get($module_url{'plistbase'});

if ( $res->is_error ) {
  print STDERR "Could not get page listing\n".$res->status_line;
  exit();
}

$res->content =~ m!<option value='(\d+)'\s*>.+?</option>[\n\s]+</select>!m;
$module_available_high = $1;

print_v("This volume has $module_available_high pages...");
$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $module_i = sprintf("%04d",$module_i);
  $module_image_url = $module_url{'imagebase'}.$module_i.".sid";
  print_v("Image URL: $module_image_url");
  push(@urls,$module_image_url);
}