# alo : Austrian Literature Online#
# The module will let you get URLs for 
# pages from Austrian Literature Online. See
# the documentation for details.


$module_default_format = "image";

%module_formats = (
  'image' => 'png',
  'png' => 'png'
);

$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};


$config{'renumber'} = 1;


$module_url{'plistbase'} = "http://www.literature.at/webinterface/library/ALO-BOOK_V01?lang=en&objid=$idno&zoom=1&page=1";
$module_url{'touchbase'} = "http://www.literature.at/webinterface/library/ALO-BOOK_V01?lang=en&objid=$idno&zoom=1&page=";
$module_url{'imagebase'} = "http://alo.uibk.ac.at:8180/filestore/servlet/GetFile?convert=image/png&scale=1&id=";


print_v("Getting page listing... (".$module_url{'plistbase'}.")");


$res = $ua->get($module_url{'plistbase'});

if ( $res->is_error ) {
  print STDERR "Could not get page listing\n".$res->status_line;
  exit();
}

$res->content =~ m!^<td align="center">Page image \d+ of (\d+)</td>$!m;
$module_available_high = $1;


print_v("This volume has $module_available_high pages...");


# Set the limit if a limit is set
$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $module_touch_url = $module_url{'touchbase'}.$module_i;
  print_v("Page URL: $module_touch_url");
  $res = $ua->get($module_touch_url);
  $res->content =~ m!id=([A-Z]+?)&!m;
  $module_image_url = $module_url{'imagebase'}.$1;
  print_v("Image URL: $module_image_url");
  push(@urls,$module_image_url);
}