# can : Canadian Literature Online#
# This module will allow you to download page images from
# the Canadian Literature Online site. See the documentation
# for additional details

$module_default_format = "image";

%module_formats = (
  'image' => 'png',
  'png'  => 'png',
  'pdf'  => 'pdf',
);

$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};


# Set the page listing base URL.
$module_url{'sitebase'}  = "http://www.canadiana.org/";
$module_url{'plistbase'} = $module_url{'sitebase'}."ECO/ItemRecord/$idno";
$module_url{'imagebase'} = $module_url{'sitebase'}."pimg/";


print_v("Getting page listing... (".$module_url{'plistbase'}.")");

$res = $ua->get($module_url{'plistbase'});

if ( $res->is_error ) {
  print STDERR "Could not get page listing\n".$res->status_line;
  exit();
}

if ( $res->content =~ m/<!-- denied message/ ) {
  print "This book is not available to the public\n";
  exit();
}

$res->content =~ m!<td class="Label">Page.+Count:</td>\n<td>\n\s+(\d+)!s;
$module_available_high = $1;

print_v("This volume has $module_available_high pages...");


$res->content =~ m!/ECO/ItemRecord/\d+\?id=([a-z0-9_]+)!s;
$module_sessid = $1;

# This is a throw-away -- just need it to register the session.
$module_url{'touchbase'} = "http://www.canadiana.org/ECO/ItemRecord/$idno?id=$module_sessid";
$ua->get($module_url{'touchbase'});


# Set the limit if a limit is set
$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $module_i = sprintf("%04d",$module_i);
  if ( $module_format eq "pdf" ) {
    $url = $module_url{'imagebase'}.$idno."-".$module_i.".pdf";
  } else {
    $url = $module_url{'imagebase'}.$module_format."/".$idno."/".$module_i."/1000/0";
  }
  print_v("Image URL: $url");
  push(@urls,$url);
}