# culnys : Cornell University Library - New York State Historical Literature#
# This module will allow you to download page images from
# the Cornell University Library - New York State Historical Literature
# documentation for additional details

$module_c = "nys";

$module_default_format = "pdf";

%module_formats = (
  'image'  => 'gif',
  'gif'    => 'gif',
);

$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};


if ( $module_format eq "gif" ) {
  $module_format = "image";
}

if ( $module_format eq "pdf" ) {
  print_v("Renumbering pages!");
  $config{'renumber'} = 1;
}

$lcidno = lc($idno);

$module_url{'sitebase'}  = "http://digital.library.cornell.edu/";
$module_url{'plistbase'} = $module_url{'sitebase'}."cgi/t/text/pageviewer-idx?c=".$module_c.";idno=nys".$idno.";view=image;seq=1";
$module_url{'touchbase'} = $module_url{'sitebase'}."cgi/t/text/pageviewer-idx?c=".$module_c.";idno=nys".$idno.";size=l;view=$module_format;seq=";
$module_url{'imagebase'} = $module_url{'sitebase'}."cache/n/y/s/nys$idno/";

print_v("Getting page listing... (".$module_url{'plistbase'}.")");


$res = $ua->get($module_url{'plistbase'});

if ( $res->content =~ m!name="nav" src="/(.*?)"!s ) {
   $module_url{'plist'} = $module_url{'sitebase'}.$1;
} else {
  print STDERR "Could not get page listing (1)\n".$res->status_line."\n";
  exit();
}


$res = $ua->get($module_url{'plist'});
print_v($module_url{'plist'});

if ( $res->is_error ) {
  print STDERR "Could not get page listing (2)\n".$res->status_line."\n";
  exit();
}

@lines = split(m!</option>!, $res->content);
pop(@lines);

my $module_available_high = $#lines;

print_v("This volume has $module_available_high pages...");

$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $module_touch_url = $module_url{'touchbase'}.$module_i;

  $module_j = sprintf("%05d",$module_i);

  $module_image_url = $module_url{'imagebase'}.$module_j.".tifl.gif";

  print_v("Touch URL: $module_touch_url");
  print_v("Image URL: $module_image_url");

  push(@touchurls,$module_touch_url);
  push(@urls,$module_image_url);
}