# hearth : Home Economics Archive: Research, Tradition and History
#
# 
# This module will allow you to download page images from
# the Core Historical Literature of Agriculture site. See
# the documentation for additional details

$module_c = "hearth";
$module_default_format = "pdf";

%module_formats = (
  'image'  => 'gif',
  'pdf'    => 'pdf',
);


$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};


if ( $module_format eq "pdf" ) {
  print_v("Renumbering pages!");
  $config{'renumber'} = 1;
}


$module_url{'sitebase'}  = "http://hearth.library.cornell.edu/";
$module_url{'plistbase'} = $module_url{'sitebase'}."cgi/t/text/pageviewer-idx?c=$module_c;idno=$idno;page=pagenav";
$module_url{'imagebase'} = $module_url{'sitebase'}."cgi/t/text/pageviewer-idx?c=$module_c;idno=$idno;size=l;view=$module_format;page=main;seq=";
$module_url{'touchbase'} = $module_url{'sitebase'}."t/text/gifcvtdir/$idno/";


print_v("Getting page listing... (".$module_url{'plistbase'}.")");


$res = $ua->get($module_url{'plistbase'});

if ( $res->is_error ) {
  print STDERR "Could not get page listing\n".$res->status_line;
  exit();
}

$res->content =~ m!<option value="(\d+)">.+?</option>\n</select>!;
$module_available_high = $1;
print_v("This volume has $module_available_high pages...");

$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $module_image_url = $module_url{'imagebase'}.$module_i;

  if ( $module_format eq "pdf" ) {
    push(@urls,$module_image_url);
    print_v("PDF URL: $module_image_url");
  }
  else {
    $module_j = sprintf("%08d",$module_i);

    $module_touch_url = $module_image_url;
    $module_image_url = $module_url{'touchbase'}."$module_j.tifl.gif";

    print_v("Touch URL: $module_touch_url");
    print_v("Touch URL: $module_image_url");

    push(@touchurls,$module_touch_url);
    push(@urls,$module_image_url);
  }

}