# hock : Hockliffe Project#
# This module will allow you to download page images from
# the Hockliffe Project site. See the documentation
# for additional details


$module_default_format = "image";

%module_formats = (
  'image'  => 'jpg',
  'jpg'    => 'jpg',
  'jpeg'   => 'jpg',
);


$module_format = module_check_format($module_default_format,keys(%module_formats));
$config{'ext'} = $module_formats{$module_format};


$module_url{'plistbase'} = "http://www.cts.dmu.ac.uk/hockliffe/$idno/";
$module_url{'imagebase'} = $module_url{'plistbase'};

# Get the page listing (so we can get the high page #)
print_v("Getting page listing: ".$module_url{'plistbase'});

# Get the introductory page (for the "Click here" link)
$res = $ua->get($module_url{'plistbase'});

if ( $res->is_error ) {
  print STDERR "Could not get page listing\n".$res->status_line;
  exit();
}

$res->content =~ m!(\d+).jpg</A>[^<]+</PRE>!s;
$module_available_high = $1;
$module_available_high =~ s/^${idno}*//;

# Set the limit if a limit is set
$module_actual_high = module_set_limit($module_available_high);


foreach $module_i ( $config{'start'} .. $module_actual_high ) {
  $i = sprintf("%03d",$module_i);
  $module_image_url = $module_url{'imagebase'}.$idno.$i.".".$config{'ext'};
  print_v("Page URL: $module_image_url");
  push(@urls,$module_image_url);
}